﻿//+------------------------------------------------------------------+
//|                                               Price Patterns.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs

input uchar Differences=5,
            Level=5,
            Forward=5,
            Pause=5;

struct func {double c[];double max;double min;double step;int size;};
func array[];
int open[],dec[],pattern[][3],size,lvl,forward;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   size=MathMax(1,Differences);
   lvl=MathMax(2,Level);
   forward=MathMax(1,Forward);
   ArrayResize(array,size);
   ArrayResize(dec,size);
   ArrayResize(open,size+1);

   int s=2;
   double a[];
   ArrayResize(a,s);
   a[0]=1;
   a[1]=-1;

   for(int i=0;i<size;i++)
     {
      array[i].size=s;
      array[i].max=-DBL_MAX;
      array[i].min=DBL_MAX;
      ArrayResize(array[i].c,s);
      ArrayCopy(array[i].c,a);
      FiniteDifference(a,s);
      dec[i]=(int)MathPow(lvl,i);
     }

   ulong f=(ulong)MathPow(lvl,size);
   if(f>INT_MAX)//ошибка - массив такого размера создать невозможно
     {
      Alert("Exceeding the size!");
      return;
     }
   else
      Print("Number of patterns ",f);

   ArrayResize(pattern,(int)f);
   ArrayInitialize(pattern,0);

//подготовка к расчетам
   int bars=MathMin(iBars(_Symbol,PERIOD_CURRENT),TerminalInfoInteger(TERMINAL_MAXBARS))-1,limit=bars-size-1;
   for(int i=bars;i>limit;i--)
      PriceShift(i);

   for(int i=limit;i>=0;i--)//ищем максимум и минимум разностей
     {
      PriceShift(i);

      for(int j=0;j<size;j++)
        {
         double value=CalcDifferences(j);

         if(array[j].max<value)
            array[j].max=value;

         if(array[j].min>value)
            array[j].min=value;
        }
     }

   for(int j=0;j<size;j++)
      array[j].step=(array[j].max-array[j].min+_Point)/lvl;

   for(int i=bars;i>limit;i--)
      PriceShift(i);

//считаем паттерны
   for(int i=limit;i>=0;i--)
     {
      PriceShift(i);

      int p=0;//индекс паттерна
      for(int j=0;j<size;j++)
        {
         double value=CalcDifferences(j);
         p=p+(int)MathFloor((value-array[j].min)/array[j].step)*dec[j];
        }

      if(i>=forward)//собираем статистику
        {
         double o=iOpen(_Symbol,PERIOD_CURRENT,i),
                h=iHigh(_Symbol,PERIOD_CURRENT,i),
                l=iLow(_Symbol,PERIOD_CURRENT,i);
         for(int j=1;j<forward;j++)
           {
            int pos=i-j;
            h=h+iHigh(_Symbol,PERIOD_CURRENT,pos);
            l=l+iLow(_Symbol,PERIOD_CURRENT,pos);
           }

         pattern[p][0]++;
         pattern[p][1]=pattern[p][1]+(int)MathRound((h/forward-o)/_Point);
         pattern[p][2]=pattern[p][2]+(int)MathRound((l/forward-o)/_Point);
        }

      if(i==0)//строим прогноз
        {
         double o=iOpen(_Symbol,PERIOD_CURRENT,i);
         if(pattern[p][0]>0)//прогноз возможен
            Predict(o+_Point*pattern[p][1]/pattern[p][0],o+_Point*pattern[p][2]/pattern[p][0]);
         else//прогноз невозможен
            Alert("Prediction impossible. This pattern is observed for the first time!");
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void Predict(double h,double l)
  {
//---
   int width=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       height=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);
   datetime t0=iTime(_Symbol,PERIOD_CURRENT,0),t1=t0+forward*PeriodSeconds(PERIOD_CURRENT);

   TrendLine("priceup",h,t0,t1,clrBlue);
   TrendLine("pricedn",l,t0,t1,clrRed);
   ChartRedraw();

   Print("Expected value high = ",NormalizeDouble(h,_Digits)," low = ",NormalizeDouble(l,_Digits));
   Sleep(Pause*1000);

   ChartScreenShot(0,"Price Patterns.png",width,height);
   ObjectsDeleteAll(0,"price");
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void TrendLine(string name,double price,datetime t0,datetime t1,color clr)
  {
//---
   ObjectCreate(0,name,OBJ_TREND,0,t0,price,t1,price);
   ObjectSetInteger(0,name,OBJPROP_WIDTH,3);
   ObjectSetInteger(0,name,OBJPROP_COLOR,clr);
   ObjectSetInteger(0,name,OBJPROP_RAY_LEFT,false);
   ObjectSetInteger(0,name,OBJPROP_RAY_RIGHT,false);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CalcDifferences(int j)
  {
//---
   double rez=0;
   for(int i=0;i<array[j].size;i++)
      rez=rez+array[j].c[i]*open[i];

   return(rez);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PriceShift(int i)
  {
//---
   for(int i=size;i>0;i--)
      open[i]=open[i-1];
   open[0]=(int)MathRound(iOpen(_Symbol,PERIOD_CURRENT,i)/_Point);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void FiniteDifference(double &a[],int &s)
  {
//---
   double b[];
   ArrayResize(b,s+1);
   ArrayInitialize(b,0);

   for(int i=0;i<s;i++)
      b[i]=a[i];

   for(int i=1;i<=s;i++)
      b[i]=MathRound(b[i]-a[i-1]);

   ArrayResize(a,s+1);
   ArrayCopy(a,b);
   s++;

   ArrayFree(b);
//---
  }
//+------------------------------------------------------------------+
